<?php
require __DIR__ . '/../auth_check.php';

$userId   = $auth['uid'];
$deviceId = $auth['device_id'] ?? null;

// 🔒 BLOCK DEVICE
$pdo->prepare("
  UPDATE user_devices
  SET is_blocked = 1
  WHERE id = ?
")->execute([$deviceId]);

// Mark future versions as unsafe
$pdo->prepare("
  UPDATE backup_files
  SET is_clean = 0
  WHERE user_id = ?
")->execute([$userId]);

// AFTER device block
file_get_contents(
  "https://api.ikc2corp.in/security/auto_rollback.php",
  false,
  stream_context_create([
    'http' => [
      'method'  => 'POST',
      'header'  => "Authorization: Bearer {$token}\r\n"
    ]
  ])
);


// 📋 INCIDENT LOG
$pdo->prepare("
  INSERT INTO incidents
    (user_id, device_id, type, severity, details, created_at)
  VALUES
    (?, ?, 'ransomware', 'critical',
     'Canary file modified – ransomware suspected', NOW())
")->execute([$userId, $deviceId]);

echo json_encode(['status' => 'locked']);
