<?php
require __DIR__ . '/../auth_check.php';
require __DIR__ . '/../core/storage/StorageFactory.php';

$userId = $auth['uid'];

// 🔍 Get all affected logical files
$stmt = $pdo->prepare("
  SELECT DISTINCT virtual_path
  FROM backup_files
  WHERE user_id = ?
");
$stmt->execute([$userId]);
$files = $stmt->fetchAll(PDO::FETCH_COLUMN);

foreach ($files as $virtualPath) {

  // ✅ Last clean version
  $stmt = $pdo->prepare("
    SELECT *
    FROM backup_files
    WHERE user_id = ?
      AND virtual_path = ?
      AND is_clean = 1
    ORDER BY version_no DESC
    LIMIT 1
  ");
  $stmt->execute([$userId, $virtualPath]);
  $clean = $stmt->fetch(PDO::FETCH_ASSOC);

  if (!$clean) continue;

  // ♻️ Restore it
  $srv = $pdo->prepare("SELECT * FROM backup_servers WHERE id=?");
  $srv->execute([$clean['server_id']]);
  $server = $srv->fetch();

  if (!$server) continue;

  try {
    $storage = getStorage($server);

    // overwrite current file with clean version
    $storage->restore(
      $clean['path'],
      "/{$userId}/{$virtualPath}"
    );

  } catch (Exception $e) {
    continue;
  }
}

// 📋 Log rollback incident
$pdo->prepare("
  INSERT INTO incidents
    (user_id, type, severity, details, created_at)
  VALUES
    (?, 'rollback', 'critical',
     'Automatic rollback to last clean backup executed',
     NOW())
")->execute([$userId]);

echo json_encode(['status' => 'rollback_complete']);
