<?php
class AnomalyScorer {

  public static function score(array $metrics): float {

    $score = 0.0;

    // % of files changed in one run
    if ($metrics['change_ratio'] > 0.6) $score += 0.30;
    if ($metrics['change_ratio'] > 0.8) $score += 0.20;

    // suspicious extensions
    if ($metrics['suspicious_ext'] > 5) $score += 0.20;

    // file size inflation
    if ($metrics['size_spike'] > 1.5) $score += 0.15;

    // speed of change
    if ($metrics['files_per_min'] > 100) $score += 0.25;

    // canary hit = instant critical
    if ($metrics['canary_touched']) $score = 1.0;

    return min(1.0, $score);
  }
}
