<?php

class LegalAuditService
{
    public static function log(PDO $pdo, array $payload): void
    {
        $record = [
            'event_type'       => $payload['event_type'],
            'actor_id'         => $payload['actor_id'] ?? null,
            'actor_role'       => $payload['actor_role'] ?? null,
            'target_user_id'   => $payload['target_user_id'] ?? null,
            'target_device_id' => $payload['target_device_id'] ?? null,
            'ip_address'       => $_SERVER['REMOTE_ADDR'] ?? null,
            'user_agent'       => $_SERVER['HTTP_USER_AGENT'] ?? null,
            'details'          => json_encode($payload['details'], JSON_THROW_ON_ERROR),
            'created_at'       => date('Y-m-d H:i:s')
        ];

        $record['checksum'] = hash(
            'sha256',
            implode('|', $record)
        );

        $stmt = $pdo->prepare("
            INSERT INTO legal_audit_log
              (event_type, actor_id, actor_role,
               target_user_id, target_device_id,
               ip_address, user_agent,
               details, created_at, checksum)
            VALUES
              (?,?,?,?,?,?,?,?,?,?)
        ");

        $stmt->execute(array_values($record));
    }
}
