<?php
function calculateEntropy(string $file): float {
    $data = file_get_contents($file, false, null, 0, 1048576); // 1MB
    $freq = array_count_values(str_split($data));
    $entropy = 0;
    $len = strlen($data);

    foreach ($freq as $count) {
        $p = $count / $len;
        $entropy -= $p * log($p, 2);
    }

    return $entropy;
}
