<?php
header("Content-Type: application/json");
require __DIR__ . "/../auth_check.php";

$userId = (int)$auth['uid'];
$fileId = $_GET['file_id'] ?? null;

if (!$fileId) {
    http_response_code(400);
    exit(json_encode(["error" => "file_id required"]));
}

$dir = __DIR__ . "/../storage/tmp_chunks/$userId/$fileId";

$uploaded = [];
if (is_dir($dir)) {
    foreach (glob("$dir/*.part") as $file) {
        $uploaded[] = (int)basename($file, '.part');
    }
}

echo json_encode([
    "uploaded_chunks" => $uploaded
]);
